﻿
#Script GetULSize.ps1
#Developed by Rob Zylowski Solution Delivery Architect Citrix Consulting Services.
#Version 1 9-6-2020
#version 2 3-12-2021
#Added code to get the actual storage used within the vhd
#Version 3 7-28-2021 
#Accounted for spaces in the OS Layer Name by encoding the disk path then adding single quotes around path
#Version 3.3 2-4-2020
#Modified to handle errors better for corrupted vdisks

<# *****************************************   LEGAL DISCLAIMER   *****************************************
This software / sample code is provided to you “AS IS” with no representations, warranties or conditions of any kind. 
You may use, modify and distribute it at your own risk. CITRIX DISCLAIMS ALL WARRANTIES WHATSOEVER, EXPRESS, IMPLIED, 
WRITTEN, ORAL OR STATUTORY, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, 
TITLE AND NONINFRINGEMENT. Without limiting the generality of the foregoing, you acknowledge and agree that (a) the 
software / sample code may exhibit errors, design flaws or other problems, possibly resulting in loss of data or damage to 
property; (b) it may not be possible to make the software / sample code fully functional; and (c) Citrix may, without notice 
or liability to you, cease to make available the current version and/or any future versions of the software / sample code. 
In no event should the software / code be used to support of ultra-hazardous activities, including but not limited to life 
support or blasting activities. NEITHER CITRIX NOR ITS AFFILIATES OR AGENTS WILL BE LIABLE, UNDER BREACH OF CONTRACT OR ANY 
OTHER THEORY OF LIABILITY, FOR ANY DAMAGES WHATSOEVER ARISING FROM USE OF THE SOFTWARE / SAMPLE CODE, INCLUDING WITHOUT 
LIMITATION DIRECT, SPECIAL, INCIDENTAL, PUNITIVE, CONSEQUENTIAL OR OTHER DAMAGES, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH 
DAMAGES. Although the copyright in the software / code belongs to Citrix, any distribution of the code should include only 
your own standard copyright attribution, and not that of Citrix. You agree to indemnify and defend Citrix against any and all
claims arising from your use, modification or distribution of the code.
********************************************************************************************************** #>
Param($EncodedPathToVHD)

function Get-ScriptDirectory
{
  $Invocation = (Get-Variable MyInvocation -Scope 1).Value
  Split-Path $Invocation.MyCommand.Path
}

#We are using a base64 string to pass the vhd filename to handle spaces in the path.
#This will convert it back for us.
$PathToVHD=[System.Text.Encoding]::Unicode.GetString([System.Convert]::FromBase64String($EncodedPathToVHD))

$ScriptSource = Get-ScriptDirectory

Set-Location "$ScriptSource\..\Diskpart"

$disk = "$PathToVHD"

Write-Host "Getting disk size for User Layer [$disk]"

#Lets see how big it 
$SizeDataSuccess = $false
NEW-ITEM –name SizevDisk.TXT –itemtype file –force | OUT-NULL
ADD-CONTENT –path SizevDisk.TXT "Select vdisk FILE=`'$disk`'" 
ADD-CONTENT –path SizevDisk.TXT "Detail vDisk" 
ADD-CONTENT –path SizevDisk.TXT "exit" 
$DetailVDISK=(DISKPART /S SizevDisk.TXT) 
$DetailVDISK | Out-File -LiteralPath DiskDetail.txt -Encoding ASCII
$SizeData = $DetailVDISK
if ($SizeData[6] -eq "DiskPart has encountered an error: The process cannot access the file because it is being used by another process.")
{
	$PhysicalDiskSize = "Disk In Use"
	$PhysicalDiskUnits = ""
}
else
{
	If ($SizeData[6] -like "*DiskPart has encountered an error*")
	{
		$Errortxt = $SizeData[6]
		Write-Host "Error: $Errortxt"
		$PhysicalDiskSize = "Error"
		$PhysicalDiskUnits = ""
	}
	else
	{
		$SizeDataSuccess=$true
		foreach ($line in $SizeData)
		{
			$arrLine = $line -split '\s+'
			if ([string]::IsNullorEmpty($arrLine[1])){continue}
			if ($arrLine[0] -eq "Virtual")
			{
				$NewDiskSize = $arrLine[2]
				Write-Host "New size for disk $disk is $NewDiskSize" -ForegroundColor Black
			}
			if ($arrLine[0] -eq "Physical")
			{
				$PhysicalDiskSize = $arrLine[2]
				$PhysicalDiskUnits = $arrLine[3]
				Write-Host "Current space used within disk $disk is $PhysicalDiskSize $PhysicalDiskUnits" -ForegroundColor Black
			}
		}
	}
}

if ($SizeDataSuccess)
{
	Write-Host "Disk Size is [$NewDiskSize]"
	Write-Host "Phycial Disk used is [$PhysicalDiskSize $PhysicalDiskUnits]"
}

Write-Host "Detaching vDisk $disk"
NEW-ITEM –name DetachvDisk.TXT –itemtype file –force | OUT-NULL
ADD-CONTENT –path DetachvDisk.TXT "Select vdisk FILE=`'$disk`'" 
ADD-CONTENT –path DetachvDisk.TXT "detach vDisk noerr" 
ADD-CONTENT –path DetachvDisk.TXT "exit" 

$DetachVDISK=(DISKPART /S DetachvDisk.TXT) 

$NewDiskSize | Out-File DiskSize.txt -Encoding ASCII

"$PhysicalDiskSize $PhysicalDiskUnits" | Out-File DiskUsed.txt -Encoding ASCII
Del DetachvDisk.TXT
Del SizevDisk.TXT

if ($SizeDataSuccess)
{
	Sleep 1
}
else
{
	Sleep 10
}